# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# Version: MPL 1.1 / GPLv3+ / LGPLv3+
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License or as specified alternatively below. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# Major Contributor(s):
# Copyright (C) 2011 Michael Stahl <mst@openoffice.org> (initial developer)
#
# All Rights Reserved.
#
# For minor contributions see the git repository.
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 3 or later (the "GPLv3+"), or
# the GNU Lesser General Public License Version 3 or later (the "LGPLv3+"),
# in which case the provisions of the GPLv3+ or the LGPLv3+ are applicable
# instead of those above.

$(eval $(call gb_CustomTarget_CustomTarget,filter/source/svg))

filter_SVGSRC := $(SRCDIR)/filter/source/svg
filter_SVGWORK := $(call gb_CustomTarget_get_workdir,filter/source/svg)

filter_SRC_svg_Tokens := $(filter_SVGSRC)/tokens.txt
filter_SRC_svg_GenToken := $(filter_SVGSRC)/gentoken.pl
filter_SRC_svg_PresentationEngine := $(filter_SVGSRC)/presentation_engine.js
filter_SRC_svg_Js2Hxx := $(filter_SVGSRC)/js2hxx.py

filter_GEN_svg_Tokens_gperf := $(filter_SVGWORK)/tokens.gperf
filter_GEN_svg_Tokens_hxx := $(filter_SVGWORK)/tokens.hxx
filter_GEN_svg_Tokens_cxx := $(filter_SVGWORK)/tokens.cxx
filter_GEN_svg_Script_hxx := $(filter_SVGWORK)/svgscript.hxx

$(filter_GEN_svg_Tokens_gperf) : \
			$(filter_SRC_svg_GenToken) $(filter_SRC_svg_Tokens) \
			| $(filter_SVGWORK)/.dir
	$(call gb_Output_announce,$@,build,GPF,3)
	$(call gb_Helper_abbreviate_dirs, \
		$(PERL) $(filter_SRC_svg_GenToken) $(filter_SRC_svg_Tokens) \
			$(filter_GEN_svg_Tokens_hxx) $(filter_GEN_svg_Tokens_gperf))

# dummy rule: both files generated by recipe above
$(filter_GEN_svg_Tokens_hxx) : $(filter_GEN_svg_Tokens_gperf)

$(filter_GEN_svg_Tokens_cxx) : $(filter_GEN_svg_Tokens_gperf)
	$(call gb_Output_announce,$@,build,GPF,1)
	$(call gb_Helper_abbreviate_dirs, \
		 $(GPERF) --compare-strncmp -C -m 20  $(filter_GEN_svg_Tokens_gperf) \
			 | sed -e "s/(char\*)0/(char\*)0$(COMMA) 0/g" \
			 > $(filter_GEN_svg_Tokens_cxx))

$(filter_GEN_svg_Script_hxx) : \
			$(filter_SRC_svg_PresentationEngine) $(filter_SRC_svg_Js2Hxx) \
			| $(filter_SVGWORK)/.dir
	$(call gb_Output_announce,$@,build,PY ,1)
	$(call gb_Helper_abbreviate_dirs, \
		$(gb_PYTHON) $(filter_SRC_svg_Js2Hxx) \
			$(filter_SRC_svg_PresentationEngine) \
			$(filter_GEN_svg_Script_hxx))

$(call gb_CustomTarget_get_target,filter/source/svg) : \
	$(filter_GEN_svg_Tokens_gperf) \
	$(filter_GEN_svg_Tokens_hxx) \
	$(filter_GEN_svg_Tokens_cxx) \
	$(filter_GEN_svg_Script_hxx) \

# vim: set noet sw=4 ts=4:
