#!/usr/bin/env bash
#
# DO NOT EDIT - this file is generated from run_unit.sh.in.
#

cmd_line="$0 $@"

# substituted variables in one place:
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
abs_top_builddir="${DIR}/.."
systemplate_path="not-set"
enable_debug=""
jails_path=""
tilecache_path=""
lo_path="/usr/lib64/libreoffice"
valgrind_cmd="valgrind --tool=memcheck --trace-children=no -v --read-var-info=yes"
verbose=''

# Note that these options are used by commands in the Makefile that
# Automake generates. Don't be mislead by 'git grep' not showing any
# use of --test-name for instance.

print_help ()
{
    echo "Usage: run_unit.sh --test-name <name.la> [OPTIONS]"
    echo "Runs a specified unit test"
    echo ""
    echo "   --log-file <file>   Log output to this file - default /dev/stderr"
    echo "   --trs-file <file>   Records the results of a test for automake (default /dev/stderr)"
    echo "   --valgrind          Run under valgrind if enabled"
    echo "   --verbose           Print out more stuff - if you run out of things to read"
    exit 1
}

tst=
tst_log=/dev/stderr
tst_output=/dev/stderr
while test $# -gt 0; do
  case $1 in
      --test-name) tst=$2; shift;;
      --log-file)  tst_log=$2; shift;;
      --trs-file)  test_output=$2; shift;;
      --valgrind)  valgrind=$valgrind_cmd; shift;;
      --verbose)   verbose="--verbose";;
      --help)      print_help ;;
  -*) ;; # ignore
  esac
  shift
done

echo
echo "Running ${tst}"
echo "	$cmd_line"

# drop .la suffix
tst=`echo $tst | sed s/\.la//`;

if test "z$tst" != "z" && test "z$CPPUNIT_TEST_NAME" != "z"; then
    # $tst is not empty, but $CPPUNIT_TEST_NAME is set, exit early if they
    # don't match.
    if test "z$tst" != "z$CPPUNIT_TEST_NAME"; then
        touch $tst_log
        echo ":test-result: SKIP $tst (disabled by CPPUNIT_TEST_NAME)" > $test_output
        exit 0;
    fi
fi

export LOOL_LOGLEVEL=trace

if test "z$enable_debug" != "ztrue"; then
    echo ""
    echo "It is necessary to configure with --enable-debug for unit tests to pass"
    echo ""
    echo ":test-result: FAIL $tst" > $test_output
    exit 1;
fi

# result logging
echo "Test output is '$test_output'"
echo > $test_output

if test "z$tst" == "z"; then
     # run the test on a dedicated port
     export LOOL_TEST_CLIENT_PORT=9984
     export LOOL_TEST_MASTER_PORT=9985

     echo "Executing external tests"
     ${valgrind} \
     ${abs_top_builddir}/loolwsd --o:sys_template_path="$systemplate_path" \
                                 --o:lo_template_path="$lo_path" \
                                 --o:child_root_path="$jails_path" \
                                 --o:tile_cache_path="$tilecache_path" \
                                 --o:storage.filesystem[@allow]=true \
                                 --o:logging.level=trace \
                                 --o:logging.file[@enable]=false \
                                 --o:ssl.key_file_path="${abs_top_builddir}/etc/key.pem" \
                                 --o:ssl.cert_file_path="${abs_top_builddir}/etc/cert.pem" \
                                 --o:ssl.ca_file_path="${abs_top_builddir}/etc/ca-chain.cert.pem" \
                                 --o:admin_console.username=admin --o:admin_console.password=admin \
                                 > "$tst_log" 2>&1 &
     echo "  executing test"

     oldpath=`pwd`
     cd "${abs_top_builddir}/test"
     if eval ${valgrind} ./test ${verbose}; then
	 echo "Test run_test.sh passed."
	 echo ":test-result: PASS run_test.sh" >> $oldpath/$test_output
	 retval=0
     else
	 echo ":test-result: FAIL run_test.sh" >> $oldpath/$test_output
	 retval=1
     fi

     echo "killing $!"
     kill $!

     exit $retval

else # newer unit tests.
    echo "Running $tst | $tst_log ...";
    if ${valgrind} \
       ${abs_top_builddir}/loolwsd --o:sys_template_path="$systemplate_path" \
                                   --o:lo_template_path="$lo_path" \
                                   --o:child_root_path="$jails_path" \
                                   --o:tile_cache_path="$tilecache_path" \
                                   --o:storage.filesystem[@allow]=true \
                                   --o:logging.level=trace \
                                   --o:ssl.key_file_path="${abs_top_builddir}/etc/key.pem" \
                                   --o:ssl.cert_file_path="${abs_top_builddir}/etc/cert.pem" \
                                   --o:ssl.ca_file_path="${abs_top_builddir}/etc/ca-chain.cert.pem" \
                                   --o:admin_console.username=admin --o:admin_console.password=admin \
                                   --unitlib="${abs_top_builddir}/test/.libs/$tst.so" 2> "$tst_log"; then
        echo "Test $tst passed."
        echo ":test-result: PASS $tst" >> $test_output
    else
	cat $tst_log
        echo "============================================================="
        echo "Test failed on unit: $tst re-run with:"
        echo "   $ gdb --args ${abs_top_builddir}/loolwsd --o:sys_template_path=\"$systemplate_path\" \\"
        echo "         --o:lo_template_path=\"$lo_path\" \\"
        echo "         --o:child_root_path=\"$jails_path\" \\"
        echo "         --o:tile_cache_path=\"$tilecache_path\" \\"
        echo "         --o:storage.filesystem[@allow]=true \\"
        echo "         --o:logging.level=trace \\"
        echo "         --o:ssl.key_file_path=\"${abs_top_builddir}/etc/key.pem\" \\"
        echo "         --o:ssl.cert_file_path=\"${abs_top_builddir}/etc/cert.pem\" \\"
        echo "         --o:ssl.ca_file_path=\"${abs_top_builddir}/etc/ca-chain.cert.pem\" \\"
        echo "         --o:admin_console.username=admin --o:admin_console.password=admin \\"
        echo "         --unitlib=\"${abs_top_builddir}/test/.libs/$tst.so\""
	echo ""
	echo "   $ less $tst_log # for detailed failure log files"
        echo "============================================================="
        echo ":test-result: FAIL $tst" >> $test_output
    fi
fi

# vim:set shiftwidth=4 expandtab:
